turtles-own [
  flockmates         ;; mnoina blzkch elv
  nearest-neighbor   ;; nejbl len hejna
]

to setup
  clear-all
  crt populace
    [ set color yellow - 2 + random 7  ;; nhodn odstny vypadaj lpe
      set size 1.5  ;; pro snaz viditelnost
      setxy random-xcor random-ycor ]
end

to go
  ask turtles [ flock ]
  ;; nsledujc dka slou k
  ;; plynulej animaci pohybu elv
  repeat 5 [ ask turtles [ fd 0.2 ] display ]
  ;; pro rychlej bh modelu na kor plynul
  ;; animace zmnte tuto dku na "turtles [ fd 1 ]"
  tick
end

to flock  ;; procedura elv
  find-flockmates
  if any? flockmates
    [ find-nearest-neighbor
      ifelse distance nearest-neighbor < minimalni-odstup
        [ separate ]
        [ align
          cohere ] ]
end

to find-flockmates  ;; procedura elv
  set flockmates other turtles in-radius vyhled
end

to find-nearest-neighbor ;; procedura elv
  set nearest-neighbor min-one-of flockmates [distance myself]
end

;;; ODKLON

to separate  ;; procedura elv
  turn-away ([heading] of nearest-neighbor) max-odklon-pri-naruseni-odstupu
end

;;; VYROVNN

to align  ;; procedura elv
  turn-towards average-flockmate-heading max-prizpusobeni-smeru
end

to-report average-flockmate-heading  ;; procedura elv
  ;; V tomto ppad nelze pouze spotat prost prmr promnnch.
  ;; Napklad prmr z hl 1 a 359 je roven nule (namsto 180), 
  ;; nebo se hodnoty hl po pekroen 359. stupn vrt na hodnotu 0. 
  ;; Proto musme ut trigonometrie.
  let x-component sum [sin heading] of flockmates
  let y-component sum [cos heading] of flockmates
  ifelse x-component = 0 and y-component = 0
    [ report heading ]
    [ report atan x-component y-component ]
end

;;; SKLON K HEJNU

to cohere  ;; procedura elv
  turn-towards average-heading-towards-flockmates max-sklon-k-hejnu
end

to-report average-heading-towards-flockmates  ;; procedura elv
  ;;"towards myself" ("smrem ke mn") vrac hodnotu smru druh elvy
  ;; k tto. My ovem chceme smr tto elvy k druh, tud k hodnot
  ;; hlu piteme 180 stup pro opanou orientaci
  let x-component mean [sin (towards myself + 180)] of flockmates
  let y-component mean [cos (towards myself + 180)] of flockmates
  ifelse x-component = 0 and y-component = 0
    [ report heading ]
    [ report atan x-component y-component ]
end

;;; POMOCN PROCEDURY

to turn-towards [new-heading max-turn]  ;; procedura elv
  turn-at-most (subtract-headings new-heading heading) max-turn
end

to turn-away [new-heading max-turn]  ;; procedura elv
  turn-at-most (subtract-headings heading new-heading) max-turn
end

 ;; oto elvu doprava podle zvolenho hlu (nebo doleva pro zporn hodnoty)
 ;; nikdy ovem ne vce, ne do maximlnho hlu, zvolenho pslunmi posuvnky
to turn-at-most [turn max-turn]  ;;procedura elv
  ifelse abs turn > max-turn
    [ ifelse turn > 0
        [ rt max-turn ]
        [ lt max-turn ] ]
    [ rt turn ]
end


;; Copyright 1998 Uri Wilensky. All rights reserved. Vechna prva vyhrazena.
;; Pln informace o prvnch podmnkch naleznete v sekci Informace.
@#$#@#$#@
GRAPHICS-WINDOW
285
10
792
538
35
35
7.0
1
10
1
1
1
0
1
1
1
-35
35
-35
35
1
1
1
ticks

CC-WINDOW
5
552
801
647
Command Center
0

BUTTON
63
95
140
128
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
146
95
227
128
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
27
52
250
85
populace
populace
1.0
1000.0
300
1.0
1
NIL
HORIZONTAL

SLIDER
4
217
280
250
max-prizpusobeni-smeru
max-prizpusobeni-smeru
0.0
20.0
5
0.25
1
stupnu
HORIZONTAL

SLIDER
4
251
280
284
max-sklon-k-hejnu
max-sklon-k-hejnu
0.0
20.0
3.5
0.25
1
stupnu
HORIZONTAL

SLIDER
4
285
280
318
max-odklon-pri-naruseni-odstupu
max-odklon-pri-naruseni-odstupu
0.0
20.0
1.5
0.25
1
stupnu
HORIZONTAL

SLIDER
28
138
251
171
vyhled
vyhled
0.0
10.0
3
0.5
1
policek
HORIZONTAL

SLIDER
28
172
251
205
minimalni-odstup
minimalni-odstup
0.0
5.0
1
0.25
1
policek
HORIZONTAL

@#$#@#$#@
CO TO JE?
---------

Tento model se sna napodobit chovn hejna ptk. (Vsledn pohyb tak pipomn pohyb hejna ryb.) Hejna objevujc v modelu nejsou pedem vytvoena ani nejsou taena njakmi zvltnmi ptky-vdci. Namsto toho se kad ptk d naprosto stejnou mnoinou pravidel, ze kterch a na rovni modelu jako celku emerguje chovn hejna. 

JAK TO FUNGUJE?
---------------

Ptci se d temi pravidly: pizpsoben smru, odklon pi naruen odstupu a sklon k hejnu.

Pizpsoben smru znamen, e se ptk postupn nat smrem, kterm let ostatn ptci v blzkm okol (v dosahu vhledu).

Odklon pi naruen odstupu znamen, e se ptk sna odklonem vyhnout druhmu, pokud pilet pli blzko (naru odstup).

Sklon k hejnu znamen, e se ptk pohybuje smrem k ostatnm ptkm v jeho blzkosti (pokud nejsou pli blzko).

Pokud jsou dva ptci pli blzko, aplikuje se dominantn pravidlo odklon pi naruen odstupu, kter pebije svm inkem ostatn dv, dokud nen zajitna vzdlenost ptk s hodnotou minimlnho odstupu.

Pouze tato ti pravidla ovlivuj smr pohybu ptk. Vichni ptci se pohybuj smrem vped, a to stejnou konstantn rychlost. 

JAK MODEL OVLDAT
-----------------

Nejdve nastavte poadovan mnostv ptk v modelu pomoc zmny hodnoty posuvnku POPULACE. Tlatkem PIPRAV vytvote do modelu ptky a nsledn je stiskem tlatka START rozpohybujte.

Pvodn nastaven posuvnk vede k pomrn vrnmu modelu formovn ptaho hejna. Pesto si s tmito parametry zkuste pohrt a vyzkouejte si rzn varianty tohoto chovn:

Ti posledn posuvnky MAX uruj maximln hel, o kter se ptk nato pi aplikaci kadho z uvedench pravidel.

VHLED uruje vzdlenost, do kter kad ptk dohldne v okruhu 360 stup. 

VIMNTE SI
-----------

Hlavn mylenkou tohoto modelu je zjitn, e hejna se mohou formovat i bez vdc.

V tomto modelu nejsou nikde pouita nhodn sla s vjimkou vchoz pozice ptk v modelu. Plynul chovn hejna podobn skutenmu chovn ptk je zpsobeno ist determinickmi pravidly.

Dle si vimnte, e se kad hejno chov dynamicky. Pestoe je hejno jednou pohromad, neznamen to, e se skld stle ze stejnch ptk. Pro myslte, e tomu tak je?

Pokud nechte model chvli bet, vichni ptci polet piblin stejnm smrem. Pro k tomuto jevu dolo?

Obas se tak ptk oddl od hejna. Jak se to me stt? Zkuste si zpomalit bh modelu a pozorovat tento jev postupn krok za krokem. 

VYZKOUEJTE SI
--------------

Zkuste experimentovat s posuvnky a uvidte, jak se budou vytvet sepjat nebo naopak rozptlen hejna, kter se budou vce i mn spojovat a rozdlovat. Bude se tak mnit jejich celkov poet a v rmci hejna se budou ptci vce i mn pesunovat z msta na msto.

Mete tak nkter pravidlo vypnout pln, pokud nastavte hodnotu pslunho posuvnku rovnu nule. Sta pouze jedno ze t uvedench pravidel k tomu, aby se vytvela hejna? A co dv pravidla? Jak dleit st chovn hejna zmiz v ppad vynechn jednotlivch pravidel?

Pokud nechte bet model dlouho, vytvo se po njak dob jedin velk hejno? Nebo se jednotliv ptci nikdy neusad a budou neustle mnit svoou formaci? Vzpomete si na to, e v modelu nejsou pouita dn nhodn sla. 

ROZEN MODELU
----------------

Pi souasnm nastaven maj ptci nastaven jist vhled kolem sebe. Co se stane, pokud by ptci vidli pouze dopedu ped sebe? K tomuto elu mete pouit primitivum IN-CONE.

Existuje zpsob, jakm vytvoit hejna ve tvaru V, jak maj hejna migrujcch hus?

Co se stane, pokud do modelu pidte stny na okraj simulovanho svta a ptci jimi nebudou moci proltat?

Jak si ptci porad s pekkami uprosted modelu?

Co by se stalo, kdybyste ptkm piadili rzn rychlosti? Napklad byste mohli pidat ptkm schopnost zrychlit svj let, pokud nejsou blzko jinch ptk, aby mli monost dohonit unikajc hejno. Nebo mete simulovat klesajc odpor vzduchu pro ppad, kdy ptci let spolen - sta jim pidat rychlost, pokud se nachz v semknut skupin.

Lze nalzt dal monosti, jak mezi sebou odliit jednotliv ptky? V modelu je mon vytvoit nhodn vchylky v populaci nebo dokonce rozliit rzn druhy ptk mezi sebou. 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------

Vimnte si, e potebujeme primitivum SUBTRACT-HEADINGS a zvltn proceduru prmrovn smru u skupin ptk. Pouh odetn nebo prmrovn zde toti nelze pout, nebo je zde diskontinuita mezi hly, zpsobujc neoekvan vsledky - po dosaen hlu 360 stup se zapot hodnota 0. Proto napklad prmr z hl 1 a 359 je roven nule (namsto 180). Msto toho je v modelu pouita trigonometrie. 

PODKOVN A ODKAZY
-------------------

Tento model je inspirovn simulac Boids, jejm autorem je Craig Reynolds. Algoritmus, pouit v modelu, je podobn pvodnmu Boids algoritmu, ale nen stejn. Na pesnch detailech tohoto algoritmu pli nezle - pi zachovn tech hlavnch parametr modelu zskte vdy chovn hejna, pipomnajc to, kter vytvoil Reynolds ve svm pvodnm modelu. Informace o Boids jsou dostupn na adrese http://www.red3d.com/cwr/boids/. 

JAK CITOVAT
-----------

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:

Wilensky, U. (1998). NetLogo Flocking model. http://ccl.northwestern.edu/netlogo/models/Flocking. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace: Copyright 1998 Uri Wilensky. All rights reserved. See http://ccl.northwestern.edu/netlogo/models/Flocking for terms of use. 

AUTORSK PRVA
--------------

Copyright 1997 Uri Wilensky. Vechna prva vyhrazena.

Oprvnn pouvat, upravovat nebo dle it tento model je udleno, pokud jsou splnny nsledujc podmnky: a) soust modelu jsou (tato) autorsk prva; b) tento model nebude dle en za elem zisku bez povolen autora (Uri Wilensky). Pro zskn licence ke komernmu vyuit kontaktujte autora.

Tento model vznikl jako soust projektu: CONNECTED MATHEMATICS: MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL MODELS (PROPOJEN MATEMATIKA: CHPN KOMPLEXNCH JEV SKRZE VYTVEN PARALELNCH MODEL ZALOENCH NA OBJEKTECH). Projekt je podporovn institutem National Science Foundation (Applications of Advanced Technologies Program) - sla grant RED #9552950 a REC #9632612.

Model byl peveden do jazyka NetLogo jako soust projektu PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT dky podpoe National Science Foundation (REPP & ROLE programs) - sla grant REC #9814682 a REC-0126227. Pevedeno z jazyka StarLogoT do jazyka NetLogo v roce 2001.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
set population 200
setup
repeat 200 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
